//=============================================================================
// MotionSensor, detects players and triggers a warning for shops.
//=============================================================================
class MSCMotionSensor extends DeusExDecoration;


#exec OBJ LOAD FILE=Ambient


#exec TEXTURE IMPORT NAME="MotionSensorGray" FILE="C:\DeusEx\MarkistanCity\Textures\CardScannerGray.pcx" GROUP=Skins
#exec TEXTURE IMPORT NAME="MotionSensorCopper" FILE="C:\DeusEx\MarkistanCity\Textures\MotionSensorCopper.pcx" GROUP=Skins
#exec TEXTURE IMPORT NAME="MotionSensorYellow" FILE="C:\DeusEx\MarkistanCity\Textures\MotionSensorYellow.pcx" GROUP=Skins
#exec TEXTURE IMPORT NAME="MotionSensorGreen" FILE="C:\DeusEx\MarkistanCity\Textures\MotionSensorGreen.pcx" GROUP=Skins

#exec MESH IMPORT MESH=MotionSensor ANIVFILE=MODELS\MotionSensor_a.3d DATAFILE=MODELS\MotionSensor_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=MotionSensor X=0 Y=0 Z=0 PITCH=0 ROLL=0 YAW=64

#exec MESH SEQUENCE MESH=MotionSensor SEQ=All              STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=MotionSensor SEQ=MotionSensor STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW   MESHMAP=MotionSensor MESH=MotionSensor
#exec MESHMAP SCALE MESHMAP=MotionSensor X=0.0214850 Y=0.0214850 Z=0.0214850

#exec MESHMAP SETTEXTURE MESHMAP=MotionSensor NUM=0 TEXTURE=MotionSensorGray
#exec MESHMAP SETTEXTURE MESHMAP=MotionSensor NUM=1 TEXTURE=MotionSensorGreen
#exec MESHMAP SETTEXTURE MESHMAP=MotionSensor NUM=2 TEXTURE=MotionSensorCopper

var float AlarmLeft, CheckTimer;
var() AlarmLight LightTrig;
var() float AlarmTime;
var() float SensorRadius;
var() AlarmLight OtherTrigs[10];
var() SensorScreen AlertScreens[5];

function Tick(float D)
{
 local DeusExMover DXM;
 local PlayerPawn A;
 local Vector V1, V2;
 local BoxSmall B;
 local int i, j;
 
 Super.Tick(D);
 
 if (AlarmLeft <= 0)
 {
  if (CheckTimer > 0)
  {
   CheckTimer -= D;
  }
  if (CheckTimer <= 0)
  {  
   forEach RadiusActors(class'PlayerPawn', A, SensorRadius, Location + (  ( vect(1,0,0) * SensorRadius ) >> Rotation  ))
   {
    if (A != None)
    {
     AlarmLeft = AlarmTime;
    }
   }
   
   CheckTimer = 1;
  }
 }
 
 if (AlarmLeft > 0)
 {
  if (!LightTrig.bIsOn)
  {
   for(i=0; i<10; i++)
   {
    if (OtherTrigs[i] != None) OtherTrigs[i].Trigger(Self, None);
   }
   for(j=0; j<5; j++)
   {
    if (AlertScreens[j] != None) AlertScreens[j].SetAlert();
   }

   LightTrig.Trigger(Self, None);
   LightTrig.AmbientSound = Sound'Klaxon3';
  }
  if (Texture != Texture'MotionSensorYellow') Texture = Texture'MotionSensorYellow';
  AlarmLeft -= D;
 }
 
 if (AlarmLeft <= 0)
 {
  if (LightTrig.bIsOn)
  {
   for(i=0; i<10; i++)
   {
    if (OtherTrigs[i] != None) OtherTrigs[i].UnTrigger(Self, None);
   }
   for(j=0; j<5; j++)
   {
    if (AlertScreens[j] != None) AlertScreens[j].SetClear();
   }
   LightTrig.AmbientSound = None;
   LightTrig.UnTrigger(Self, None);
  }
  if (Texture != Texture'MotionSensorGreen') Texture = Texture'MotionSensorGreen';
 }
}

function Frob(Actor Frobber, Inventory frobWith)
{
}

defaultproperties
{
     bInvincible=True
     ItemName="Motion Sensor"
     bPushable=False
     Physics=PHYS_None
     Mesh=LodMesh'MotionSensor'
     DrawScale=0.450000
     CollisionRadius=5.260000
     CollisionHeight=5.940000
     Mass=999.000000
     Buoyancy=12.000000
     LightType=LT_Steady
     LightRadius=6
     LightBrightness=40
     LightHue=35
     LightSaturation=51
     SensorRadius=128.000000
     AlarmTime=10.000000
     Texture=Texture'MotionSensorGreen'
}
